/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.property.VWRoutePropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWWorkflowPropPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class VWTrackerProperty
extends JPanel
implements ItemSelectable,
ItemListener,
IVWPropertyChangeListener {
    protected VWTrkDataModel m_trackerDataModel = null;
    protected Frame m_parentFrame = null;
    protected JTabbedPane m_propertyTabbedPane = new JTabbedPane(){

        public void addNotify() {
            super.addNotify();
            Font boldFont = null;
            Font font = null;
            font = this.getFont();
            if (font != null && (boldFont = new Font(font.getName(), 1, font.getSize())) != null) {
                this.setFont(boldFont);
            }
        }
    };
    private VWWorkflowPropPanel m_workflowPropPanel = null;
    protected VWStepPropPanel m_stepPropPanel = null;
    protected VWRoutePropPanel m_routePropPanel = null;
    protected JPanel m_tabPanel = new JPanel(new BorderLayout());
    private JScrollPane m_scrollPane = null;
    private int m_minWidth = 150;
    private int m_minHeight = 500;
    private ItemListener m_selectListeners = null;
    private int m_stepTabIndex = -1;

    public VWTrackerProperty(Frame parentFrame, VWTrkDataModel trackerDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = trackerDataModel;
        Dimension minDim = VWStringUtils.stringToDimension(VWResource.s_propertyPaneMinimumDim);
        if (minDim != null) {
            this.m_minWidth = minDim.width;
            this.m_minHeight = minDim.height;
        }
        this.m_workflowPropPanel = new VWWorkflowPropPanel(this.m_parentFrame, this.m_trackerDataModel);
        this.updatePanelsComponentOrientation(this.m_workflowPropPanel);
        this.m_stepPropPanel = new VWStepPropPanel(this.m_parentFrame, this.m_trackerDataModel);
        this.updatePanelsComponentOrientation(this.m_stepPropPanel);
        this.m_routePropPanel = new VWRoutePropPanel(this.m_parentFrame, this.m_trackerDataModel);
        this.updatePanelsComponentOrientation(this.m_routePropPanel);
        this.m_propertyTabbedPane.addTab(VWResource.s_workflow, this.m_workflowPropPanel);
        this.m_propertyTabbedPane.addTab(VWResource.s_step, this.m_stepPropPanel);
        this.m_propertyTabbedPane.addTab(VWResource.s_route, this.m_routePropPanel);
        this.m_stepTabIndex = this.m_propertyTabbedPane.indexOfComponent(this.m_stepPropPanel);
        this.m_tabPanel.add((Component)this.m_propertyTabbedPane, "Center");
        this.m_scrollPane = new JScrollPane(this.m_tabPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_scrollPane, "Center");
        this.m_stepPropPanel.addItemListener(this);
        this.m_routePropPanel.addItemListener(this);
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
    }

    public void initialize() {
        if (this.m_workflowPropPanel != null) {
            this.m_workflowPropPanel.initialize();
        }
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.initialize();
        }
        if (this.m_routePropPanel != null) {
            this.m_routePropPanel.initialize();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.m_propertyTabbedPane != null) {
            Dimension dim = this.getPreferredSize();
            Insets insets = this.m_scrollPane.getInsets();
            JScrollBar scrollBar = null;
            scrollBar = this.m_scrollPane.getVerticalScrollBar();
            if (scrollBar != null) {
                width -= scrollBar.getWidth();
            }
            if ((scrollBar = this.m_scrollPane.getHorizontalScrollBar()) != null) {
                height -= scrollBar.getHeight();
            }
            height -= insets.top + insets.bottom;
            if ((width -= insets.left + insets.right) < this.m_minWidth) {
                width = this.m_minWidth;
            }
            if (height < this.m_minHeight) {
                height = this.m_minHeight;
            }
            dim.setSize(width, height);
            this.m_propertyTabbedPane.setPreferredSize(dim);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this) {
            return;
        }
        if (source == this.m_stepPropPanel || source == this.m_routePropPanel) {
            this.notifySelectListeners(e);
        } else {
            boolean bStepSelected = false;
            boolean bRouteSelected = false;
            ItemSelectable itemSelectable = e.getItemSelectable();
            Object[] objects = itemSelectable.getSelectedObjects();
            if (objects != null && objects.length > 0) {
                Object obj = objects[0];
                if (obj instanceof VWMapNode) {
                    bStepSelected = true;
                } else if (obj instanceof VWRouteDefinition) {
                    bRouteSelected = true;
                }
            }
            this.m_stepPropPanel.itemStateChanged(e);
            this.m_routePropPanel.itemStateChanged(e);
            if (bStepSelected) {
                this.m_propertyTabbedPane.setSelectedComponent(this.m_stepPropPanel);
            } else if (bRouteSelected) {
                this.m_propertyTabbedPane.setSelectedComponent(this.m_routePropPanel);
            }
        }
        this.m_propertyTabbedPane.setIconAt(this.m_stepTabIndex, this.m_stepPropPanel.getLockedStatusIcon());
    }

    public void showWorkflowPropertyPane() {
        this.m_propertyTabbedPane.setSelectedComponent(this.m_workflowPropPanel);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    protected void notifySelectListeners(ItemEvent e) {
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(new ItemEvent(this, 0, this, e.getStateChange()));
        }
    }

    public Object[] getSelectedObjects() {
        int count;
        Object[] selectedSteps = this.m_stepPropPanel.getSelectedObjects();
        Object[] selectedRoutes = this.m_routePropPanel.getSelectedObjects();
        int stepCount = 0;
        int routeCount = 0;
        if (selectedSteps != null) {
            stepCount = selectedSteps.length;
        }
        if (selectedRoutes != null) {
            routeCount = selectedRoutes.length;
        }
        if ((count = stepCount + routeCount) == 0) {
            return null;
        }
        Object[] objArray = new Object[stepCount + routeCount];
        if (stepCount > 0) {
            System.arraycopy(selectedSteps, 0, objArray, 0, stepCount);
        }
        if (routeCount > 0) {
            System.arraycopy(selectedRoutes, 0, objArray, stepCount, routeCount);
        }
        return objArray;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 701: 
                case 704: 
                case 705: {
                    this.m_propertyTabbedPane.setIconAt(this.m_stepTabIndex, this.m_stepPropPanel.getLockedStatusIcon());
                }
            }
        }
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        this.m_parentFrame = null;
        if (this.m_propertyTabbedPane != null) {
            this.m_propertyTabbedPane.removeAll();
            this.m_propertyTabbedPane = null;
        }
        if (this.m_workflowPropPanel != null) {
            this.m_workflowPropPanel.removeReferences();
            this.m_workflowPropPanel = null;
        }
        if (this.m_stepPropPanel != null) {
            this.m_stepPropPanel.removeItemListener(this);
            this.m_stepPropPanel.removeReferences();
            this.m_stepPropPanel = null;
        }
        if (this.m_routePropPanel != null) {
            this.m_routePropPanel.removeItemListener(this);
            this.m_routePropPanel.removeReferences();
            this.m_routePropPanel = null;
        }
        if (this.m_tabPanel != null) {
            this.m_tabPanel.removeAll();
            this.m_tabPanel.setLayout(null);
            this.m_tabPanel = null;
        }
        if (this.m_scrollPane != null) {
            this.m_scrollPane.removeAll();
            this.m_scrollPane = null;
        }
        this.m_selectListeners = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.removeAll();
        this.setLayout(null);
    }

    protected void updatePanelsComponentOrientation(JPanel canvasPanel) {
        try {
            if (canvasPanel != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                canvasPanel.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

